/*******************************************************
Filename		:  di_group_type.sql
Release 		:  c2.0
SIR			:  1509
Description		:  Creates the dimension table DI_GROUP_TYPE and related objects.
Author			:  Thieu Nguyen
Date			:  7/15/2003
Comments		:  
**********************************************************/

connect storetw/storetw@storet.sdc
spool di_group_type.log

drop sequence seq_group_type;

create sequence seq_group_type
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_group_type;
create table di_group_type
(PK_ISN number(12) not null,
 BIO_GROUP_TYPE varchar2(32) not null)
tablespace storetdata
storage (initial 256K next 256K)
nologging;

alter table di_group_type
add constraint pk_group_type primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128K next 128K);

--add data to di_group_type
set serveroutput on
declare
cursor c1 is select distinct BIO_GROUP_TYPE from fa_biological_result
where BIO_GROUP_TYPE is not null;
begin
for c1_var in c1 loop
insert into di_group_type(PK_ISN,BIO_GROUP_TYPE)
values(seq_group_type.nextval,c1_var.BIO_GROUP_TYPE);
end loop;
commit;
end;
/

--update fks in FA_BIOLOGICAL_RESULT
declare
cursor c1 is select * from di_group_type;

begin
for c1_var in c1 loop
update FA_BIOLOGICAL_RESULT
set FK_GROUP_TYPE = c1_var.pk_isn
where BIO_GROUP_TYPE = c1_var.BIO_GROUP_TYPE;
end loop;
commit;
end;
/
spool off;
